#include "otpch.h"
#include "botmanager.h"

#include "game.h"
#include "scheduler.h"
#include "monsters.h"
#include "monster.h"
#include "tile.h"
#include "combat.h"

extern Game g_game;
extern MonsterEvents* g_monsterEvents;

// Time names e posições fixas
const std::string teamNames[4] = { "KnightBot", "PaladinBot", "DruidBot", "MageBot" };
const Position spawnPositions[4] = {
    Position(1000, 1000, 7),
    Position(1010, 1000, 7),
    Position(1000, 1010, 7),
    Position(1010, 1010, 7)
};
const Position basePos(1005, 1005, 7);

void BotManager::init()
{
    g_scheduler.addEvent(createSchedulerTask(1000, std::bind(&BotManager::spawnLoop, this)));
}

void BotManager::spawnLoop()
{
    for (int team = 0; team < 4; ++team) {
        MonsterType* mType = g_monsters.getMonsterType(teamNames[team]);
        if (!mType) {
            std::cout << "[BotManager] MonsterType not found: " << teamNames[team] << std::endl;
            continue;
        }

        std::ostringstream botName;
        botName << teamNames[team] << Otb::rand(1000, 9999);

        Monster* bot = new Monster(mType);
        bot->setCustomName(botName.str());
        bot->setSkull(SKULL_GREEN); // Visível
        bot->setGuildId(team + 1); // Guild id representa o time
        bot->setGuildLevel(GUILDLEVEL_MEMBER);

        if (!g_game.placeCreature(bot, spawnPositions[team], false, true)) {
            delete bot;
            continue;
        }

        bots.push_back(bot);
    }

    g_scheduler.addEvent(createSchedulerTask(60000, std::bind(&BotManager::spawnLoop, this))); // Repetir a cada minuto
}

void BotManager::onThink(uint32_t)
{
    for (Monster* bot : bots) {
        if (!bot || bot->isRemoved()) continue;

        // Movimento em direção ao centro
        Direction dir = getDirectionTo(bot->getPosition(), basePos);
        Position nextPos = getNextPosition(dir, bot->getPosition());

        Tile* tile = g_game.map.getTile(nextPos);
        if (tile && !tile->hasFlag(TILESTATE_BLOCKSOLID)) {
            g_game.internalMoveCreature(bot, dir);
        }

        // Encontrar inimigo ao redor (em raio 5)
        SpectatorVec list;
        g_game.map.getSpectators(list, bot->getPosition(), false, true, 5, 5, 5, 5);

        for (Creature* creature : list) {
            Monster* target = creature->getMonster();
            if (!target || target == bot) continue;

            if (bot->getGuildId() > 0 && target->getGuildId() > 0) {
                if (bot->getGuildId() != target->getGuildId()) {
                    bot->selectTarget(target);
                    break;
                }
            }
        }
    }

    g_scheduler.addEvent(createSchedulerTask(1000, std::bind(&BotManager::onThink, this, 0)));
}
